/**
 * $Id: editor_plugin_src.js 520 2008-01-07 16:30:32Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	tinymce.create('tinymce.plugins.Maple4Plugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('mceMaple', function() {
				ed.windowManager.open({
					file : url + '/maple4.htm',
					width : 300 + parseInt(ed.getLang('maple4.delta_width', 0)),
					height : 160 + parseInt(ed.getLang('maple4.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			// Register buttons
			ed.addButton('maple4', 
			{title : 'Add Objects for Maple4 Site Creator', 
			cmd : 'mceMaple',
			image : url + '/img/icon.gif'
			});
		},



		getInfo : function() {
			return {
				longname : 'Maple4',
				author : 'Igor Croschin',
				authorurl : 'http://maple4.ru',
				infourl : 'http://maple4.ru',
				version : "1" 
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('maple4', tinymce.plugins.Maple4Plugin);
})();